#include "GLOBAL.H"
#include "MCU.H"


//-----MCU.C-----//
extern BYTE Wdt;                                 // Watch Dog Timer Default Value
extern void Initial_Mcu( void );

//-----KEYBOARD.C-----//
extern void Initial_KB( void );
extern void KB_Scan_Key( void );
extern void KB_Send_Key( void );

//-----MOUSE.C-----//
extern void Initial_MS( void );
extern void MS_Send_Key( void );

//-----SPEAKER.C-----//
extern void Initial_SPK( void );

//-----USB.C-----//
extern void Initial_USB( void );


void main( void )
  { Initial_Mcu();                               // Initial 8051 SFR
    Initial_KB();
    Initial_MS();
    Initial_SPK();
    Initial_USB();                               // USB.C
    while(1)
      { WDTCR = Wdt;
        
        KB_Scan_Key();
        KB_Send_Key();
        
        MS_Send_Key();
      }   
  }
